<?php
require('fpdf/fpdf.php');

function convertImagesToPDF($images, $pdfFileName, $orientation = 'P', $size = 'A4', $compression = 'none') {
    $pdf = new FPDF($orientation, 'mm', $size);
    
    foreach ($images as $image) {
        // Get image dimensions
        list($width, $height) = getimagesize($image);
        $pdf->AddPage();

        // Calculate image size to fit the PDF page
        $pageWidth = $pdf->GetPageWidth() - 20; // 10mm margins on both sides
        $pageHeight = $pdf->GetPageHeight() - 20;

        // Calculate aspect ratio
        $aspectRatio = $width / $height;

        // Resize image while maintaining aspect ratio
        if ($width > $height) {
            $newWidth = $pageWidth;
            $newHeight = $pageWidth / $aspectRatio;
            if ($newHeight > $pageHeight) {
                $newHeight = $pageHeight;
                $newWidth = $pageHeight * $aspectRatio;
            }
        } else {
            $newHeight = $pageHeight;
            $newWidth = $pageHeight * $aspectRatio;
            if ($newWidth > $pageWidth) {
                $newWidth = $pageWidth;
                $newHeight = $pageWidth / $aspectRatio;
            }
        }

        // Center the image on the page
        $x = ($pageWidth - $newWidth) / 2 + 10;
        $y = ($pageHeight - $newHeight) / 2 + 10;

        // Apply compression if needed
        if ($compression === 'low') {
            imagejpeg(imagecreatefromjpeg($image), $image, 60);
        } elseif ($compression === 'high') {
            imagejpeg(imagecreatefromjpeg($image), $image, 30);
        }

        $pdf->Image($image, $x, $y, $newWidth, $newHeight);
    }

    // Output PDF
    $pdf->Output('F', $pdfFileName);
}
?>
