<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Basic Meta Tags -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pic to PDF Converter - Free Image to PDF Tool</title>

    <!-- Favicon Icon -->
    <link rel="icon" href="favicon.png" type="image/png">
    <link rel="shortcut icon" href="favicon.png" type="image/png">
    <link rel="apple-touch-icon" href="favicon.png">

    <!-- SEO Optimization -->
    <meta name="description" content="Convert your images (JPG, PNG, WEBP, GIF, BMP) to PDF easily with our free online Pic to PDF converter. No registration required!">
    <meta name="keywords" content="Pic to PDF, Image to PDF, JPG to PDF, PNG to PDF, PDF Converter, Free PDF Tool, Online Image to PDF, PDF generator">
    <meta name="author" content="PicToPDF Tool">
    <meta name="robots" content="index, follow">
    <meta property="og:title" content="Pic to PDF Converter - Free Online Image to PDF Tool">
    <meta property="og:description" content="Easily convert images (JPG, PNG, WEBP, GIF, BMP) to PDF with PicToPDF - fast, free, and secure.">
    <meta property="og:url" content="https://pics2pdf.com/">
    <meta property="og:type" content="website">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Pic to PDF Converter - Free Online Image to PDF Tool">
    <meta name="twitter:description" content="Convert images (JPG, PNG, WEBP, GIF, BMP) to PDF easily with our free online PicToPDF converter.">

    <!-- CSS Link -->
    <link rel="stylesheet" href="style.css?v=<?php echo time(); ?>">
</head>

<body>

    <!-- Header -->
    <div class="header">
        <h1>Pic to PDF Converter</h1>
        <div class="menu">
            <a href="index.php">Home</a>
            <a href="about.php">About</a>
            <a href="contact.php">Contact</a>
            <a href="privacy.php">Privacy Policy</a>
        </div>
    </div>

    <!-- Main Container -->
    <div class="container">
        <h3>Convert Image to PDF</h3>
        <p>Select images (JPG, PNG, WEBP, GIF, BMP) to convert into a single PDF.</p>

        <div class="upload-section">
            <form id="uploadForm" action="upload.php" method="post" enctype="multipart/form-data">
                <!-- File Input -->
                <input type="file" id="imageInput" name="images[]" multiple accept="image/*" required>
                <div id="imagePreview" class="image-preview"></div>

                <!-- PDF Settings (Horizontal Layout) -->
                <div class="pdf-settings">
                    <div>
                        <label>Orientation:</label>
                        <select name="orientation" id="orientation">
                            <option value="P">Portrait</option>
                            <option value="L">Landscape</option>
                        </select>
                    </div>

                    <div>
                        <label>Page Size:</label>
                        <select name="size" id="size">
                            <option value="A4">A4</option>
                            <option value="Letter">Letter</option>
                        </select>
                    </div>

                    <div>
                        <label>Compression:</label>
                        <select name="compression" id="compression">
                            <option value="none">None</option>
                            <option value="low">Low</option>
                            <option value="high">High</option>
                        </select>
                    </div>
                </div>

                <!-- Convert Button -->
                <button type="submit" name="submit" id="convertBtn">Convert to PDF</button>
            </form>
        </div>

        <!-- Dark Mode Toggle -->
        <div class="dark-mode-toggle">
            <label for="darkModeSwitch">Dark Mode:</label>
            <input type="checkbox" id="darkModeSwitch" />
        </div>
    </div>

    <!-- How to Use Section -->
    <div class="how-to-use">
        <h2><strong>How to Use</strong></h2>
        <p>Follow these simple steps to convert your images to a PDF file:</p>

        <ol class="how-to-steps">
            <li><strong>Step 1: Select Images</strong>  
                <br>Click on the <b>"Choose Files"</b> button and select one or multiple images.  
                <br>Supported formats: JPG, PNG, WEBP, GIF, BMP.
            </li>

            <li><strong>Step 2: Adjust Settings</strong>  
                <br>Choose the desired <b>Orientation (Portrait/Landscape)</b>, <b>Page Size (A4/Letter)</b>, and <b>Compression</b> level if needed.
            </li>

            <li><strong>Step 3: Convert Images</strong>  
                <br>Click on the <b>"Convert to PDF"</b> button.  
                <br>The tool will automatically process and convert the images into a PDF file.
            </li>

            <li><strong>Step 4: Download PDF</strong>  
                <br>Once the PDF is ready, it will be <b>automatically downloaded</b> to your device.
            </li>

            <li><strong>Optional:</strong>  
                <br>You can toggle the <b>"Dark Mode"</b> option for a comfortable viewing experience.
            </li>
        </ol>

        <p class="note">📄 <strong>Note:</strong> Each image should not exceed <b>20MB</b> in size.</p>
    </div>

    <!-- Footer -->
    <div class="footer">
        &copy; 2025 PicToPDF Tool. All rights reserved.
    </div>

    <!-- JavaScript for Image Preview and Dark Mode -->
    <script>
        // Image Preview
        document.getElementById('imageInput').addEventListener('change', function () {
            const preview = document.getElementById('imagePreview');
            preview.innerHTML = '';
            Array.from(this.files).forEach(file => {
                const img = document.createElement('img');
                img.src = URL.createObjectURL(file);
                img.style.height = '100px';
                img.style.margin = '5px';
                preview.appendChild(img);
            });
        });

        // Dark Mode Toggle
        const darkModeSwitch = document.getElementById('darkModeSwitch');
        darkModeSwitch.addEventListener('change', () => {
            document.body.classList.toggle('dark-mode');
        });
    </script>

</body>
</html>
